/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.util.OleBlob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import net.ucanaccess.jdbc.UcanaccessSQLException;

public class BlobKey
implements Serializable {
    private static final long serialVersionUID = -8580858159403159903L;
    private HashMap<String, Object> key;
    private String tableName;
    private String columnName;
    public static final int MAX_SIZE = 4096;

    public BlobKey(HashMap<String, Object> _key, String _tableName, String _columnName) {
        this.key = _key;
        this.tableName = _tableName;
        this.columnName = _columnName;
    }

    public BlobKey(Table _table, String _columnName, Row _row) {
        this.tableName = _table.getName();
        this.columnName = _columnName;
        if (BlobKey.hasPrimaryKey(_table)) {
            List cl = _table.getPrimaryKeyIndex().getColumns();
            HashMap<String, Object> keyMap = new HashMap<String, Object>();
            for (Index.Column c : cl) {
                keyMap.put(c.getName(), _row.get((Object)c.getName()));
            }
            this.key = keyMap;
        }
    }

    public static boolean hasPrimaryKey(Table _table) {
        for (Index idx : _table.getIndexes()) {
            if (!idx.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public OleBlob getOleBlob(Database db) throws UcanaccessSQLException {
        try {
            Table t = db.getTable(this.tableName);
            IndexCursor c = CursorBuilder.createPrimaryKeyCursor((Table)t);
            return c.findFirstRow(this.key) ? c.getCurrentRow().getBlob(this.columnName) : null;
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public byte[] getBytes() throws UcanaccessSQLException {
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bais);
            oos.writeObject(this);
            oos.flush();
            return bais.toByteArray();
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public static BlobKey getBlobKey(byte[] bt) {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(bt);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = ois.readObject();
            return obj instanceof BlobKey ? (BlobKey)obj : null;
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static BlobKey getBlobKey(InputStream is) {
        byte[] bt = new byte[4096];
        try {
            is.read(bt);
            return BlobKey.getBlobKey(bt);
        }
        catch (IOException e) {
            return null;
        }
    }

    public HashMap<String, Object> getKey() {
        return this.key;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

